varying vec2 v_texCoord;

uniform vec4 Tangent;
uniform vec4 Normal;
uniform vec4 BiNormal;

uniform vec4 Eye;
varying vec3 EyeDir;

varying vec4 diffuse,ambientGlobal,ambient;
varying vec3 normal,lightDir,halfVector;
varying float dist;

void main( void )
{
    v_texCoord = gl_MultiTexCoord0.xy;

     mat3 TBN_Matrix;  
     TBN_Matrix[0] =  gl_NormalMatrix * Tangent.xyz; 
     TBN_Matrix[1] =  gl_NormalMatrix * -BiNormal.xyz; 
     TBN_Matrix[2] =  gl_NormalMatrix * Normal.xyz; 
   
     vec4 Vertex_ModelView = gl_ModelViewMatrix * gl_Vertex; 
     EyeDir = vec3(-Vertex_ModelView) * TBN_Matrix;      

	vec4 ecPos;
	vec3 aux;
	
	/* first transform the normal into eye space and normalize the result */
	normal = normalize(gl_NormalMatrix * gl_Normal);
	
	ecPos = gl_ModelViewMatrix * gl_Vertex;
	aux = vec3(gl_LightSource[0].position-ecPos);
	lightDir = normalize(aux);
	
	/* compute the distance to the light source to a varying variable*/
	dist = length(aux);

	/* Normalize the halfVector to pass it to the fragment shader */
	halfVector = normalize(gl_LightSource[0].halfVector.xyz);
	
	/* Compute the diffuse, ambient and globalAmbient terms */
	diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
	ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
	ambientGlobal = gl_LightModel.ambient * gl_FrontMaterial.ambient;

     // Vertex transformation 
    gl_Position = ftransform(); 
}
