uniform sampler2D testTexture;
uniform sampler2D HeightTexture;
varying vec2 v_texCoord;
varying vec3 EyeDir;


varying vec4 diffuse,ambientGlobal, ambient;
varying vec3 normal,lightDir,halfVector;
varying float dist;

void main( void )
{
    
	vec3 n,halfV,viewV,ldir;
	float NdotL,NdotHV;
	vec4 color = ambientGlobal;
	float att;
	
	n = normalize(normal);
	NdotL = max(dot(n,normalize(lightDir)),0.0);

	if (NdotL > 0.0) 
	{
	
		att = 1.0 / (gl_LightSource[0].constantAttenuation +
				gl_LightSource[0].linearAttenuation * dist +
				gl_LightSource[0].quadraticAttenuation * dist * dist);
		color += att * (diffuse * NdotL + ambient);
	
		
		halfV = normalize(halfVector);
		/*NdotHV = max(dot(n,halfV),0.0);
		color += att * gl_FrontMaterial.specular * gl_LightSource[0].specular * pow(NdotHV,gl_FrontMaterial.shininess);*/
	}


    vec3 EyeT = normalize(EyeDir);
    vec4 Offset = texture2D(HeightTexture,v_texCoord);
    Offset = Offset * 0.04 - 0.02;
    vec2 TexCoords = Offset.xy * EyeT.xy + v_texCoord;

    gl_FragColor = texture2D( testTexture, TexCoords ); 
}
