uniform sampler2DShadow shadowMap;
varying vec4  projCoord;
uniform sampler2D testTexture;
uniform sampler2D HeightTexture;
varying vec2 v_texCoord;

varying vec3 EyeDir;

void main ()
{
    vec3 EyeT = normalize(EyeDir);
    vec4 Offset = texture2D(HeightTexture,v_texCoord);
    Offset = Offset * 0.04 - 0.02;
    vec2 TexCoords = Offset.xy * EyeT.xy + v_texCoord;
    vec4 parallaxcolor = texture2D( testTexture, TexCoords ); 

	const float kTransparency = 0.4;
	vec4 color = gl_Color;
	
	vec3 shadowUV = projCoord.xyz / projCoord.q;
	float mapScale = 1.0 / 512.0;

	vec4 shadowColor = shadow2D(shadowMap, shadowUV);

	shadowColor += shadow2D(shadowMap, shadowUV.xyz + vec3( mapScale,  mapScale, 0));
	shadowColor += shadow2D(shadowMap, shadowUV.xyz + vec3( mapScale, -mapScale, 0));
	shadowColor += shadow2D(shadowMap, shadowUV.xyz + vec3( mapScale,  	  0, 0));
	shadowColor += shadow2D(shadowMap, shadowUV.xyz + vec3(-mapScale,  mapScale, 0));
	shadowColor += shadow2D(shadowMap, shadowUV.xyz + vec3(-mapScale, -mapScale, 0));
	shadowColor += shadow2D(shadowMap, shadowUV.xyz + vec3(-mapScale,  	  0, 0));
	shadowColor += shadow2D(shadowMap, shadowUV.xyz + vec3(        0,  mapScale, 0));
	shadowColor += shadow2D(shadowMap, shadowUV.xyz + vec3(        0, -mapScale, 0));

	shadowColor = shadowColor / 9.0;

	shadowColor += kTransparency;
	shadowColor = clamp(shadowColor, 0.0, 1.0);

	vec4 color_map = texture2D(testTexture, gl_TexCoord[0].st);

	if(shadowUV.x >= 0.0 && shadowUV.y >= 0.0 && shadowUV.x <= 1.0 && shadowUV.y <= 1.0 )
   	{
		gl_FragColor = (color * shadowColor)*parallaxcolor;
		//gl_FragColor = color;
		gl_FragColor.a = 1.0;
	}
	else
	{
		gl_FragColor = color*parallaxcolor;
		//gl_FragColor = color;
		gl_FragColor.a = 1.0;
	}
}

