uniform sampler2DShadow shadowMap;
varying vec4  projCoord;
uniform sampler2D testTexture;
uniform sampler2D HeightTexture;
varying vec2 v_texCoord;

varying vec3 EyeDir;

void main ()
{
    vec3 EyeT = normalize(EyeDir);
    vec4 Offset = texture2D(HeightTexture,v_texCoord);
    Offset = Offset * 0.04 - 0.02;
    vec2 TexCoords = Offset.xy * EyeT.xy + v_texCoord;
    vec4 parallaxcolor = texture2D( testTexture, TexCoords ); 

	const float kTransparency = 0.4;
	vec4 color = gl_Color;

	float rValue = shadow2DProj(shadowMap, projCoord).r + kTransparency;
	rValue = clamp(rValue, 0.0, 1.0);

	vec3 coordPos  = projCoord.xyz / projCoord.w;
	vec4 color_map = texture2D(testTexture, gl_TexCoord[0].st);

	if(coordPos.x >= 0.0 && coordPos.y >= 0.0 && coordPos.x <= 1.0 && coordPos.y <= 1.0 )
   	{
		gl_FragColor = (color * rValue)*parallaxcolor;
		//gl_FragColor = color;
		gl_FragColor.a = 1.0;
	}
	else
	{
		gl_FragColor = color*parallaxcolor;
		//gl_FragColor = color;
		gl_FragColor.a = 1.0;
	}
}

