varying vec4 diffuse,ambient;
varying vec3 normal,lightDir,halfVector;
//uniform sampler2D tex;

uniform sampler2DShadow shadowMap;
uniform sampler2D diffuseTex;
varying vec4 projCoord;

void main()
{
	/** pixel light pass */
	vec3 n,halfV,viewV,ldir;
	float NdotL,NdotHV;
	vec4 color = ambient;
	
	/* a fragment shader can't write a verying variable, hence we need
	a new variable to store the normalized interpolated normal */
	n = normalize(normal);
	
	/* compute the dot product between normal and ldir */
	NdotL = max(dot(n,lightDir),0.0);

	if (NdotL > 0.0) {
		halfV = normalize(halfVector);
		NdotHV = max(dot(n,halfV),0.0);
		color += gl_FrontMaterial.specular * gl_LightSource[0].specular * pow(NdotHV,gl_FrontMaterial.shininess);
		color += diffuse * NdotL;
	}

	
	/** shadow map pass */
	const float kTransparency = 0.4;

	float rValue = shadow2DProj(shadowMap, projCoord).r + kTransparency;
	rValue = clamp(rValue, 0.0, 1.0);

	vec3 coordPos  = projCoord.xyz / projCoord.w;
	vec4 color_map = texture2D(diffuseTex, gl_TexCoord[0].st);

	if(coordPos.x >= 0.0 && coordPos.y >= 0.0 && coordPos.x <= 1.0 && coordPos.y <= 1.0 )
   	{
		gl_FragColor = (color * rValue)*color_map;
		//gl_FragColor = color;
		gl_FragColor.a = 1.0;
	}
	else
	{
		gl_FragColor = color*color_map;
		//gl_FragColor = color;
		gl_FragColor.a = 1.0;
	}
}