uniform sampler2DShadow shadowMap;
uniform sampler2D diffuseTex;
varying vec4  projCoord;
varying vec2  TexCoord;

void main ()
{

	const float kTransparency = 0.4;
	vec4 color = gl_Color;
	
	vec3 shadowUV = projCoord.xyz / projCoord.q;
	float mapScale = 1.0 / 512.0;

	vec4 shadowColor = shadow2D(shadowMap, shadowUV);

	shadowColor += shadow2D(shadowMap, shadowUV.xyz + vec3( mapScale,  mapScale, 0));
	shadowColor += shadow2D(shadowMap, shadowUV.xyz + vec3( mapScale, -mapScale, 0));
	shadowColor += shadow2D(shadowMap, shadowUV.xyz + vec3( mapScale,  	  0, 0));
	shadowColor += shadow2D(shadowMap, shadowUV.xyz + vec3(-mapScale,  mapScale, 0));
	shadowColor += shadow2D(shadowMap, shadowUV.xyz + vec3(-mapScale, -mapScale, 0));
	shadowColor += shadow2D(shadowMap, shadowUV.xyz + vec3(-mapScale,  	  0, 0));
	shadowColor += shadow2D(shadowMap, shadowUV.xyz + vec3(        0,  mapScale, 0));
	shadowColor += shadow2D(shadowMap, shadowUV.xyz + vec3(        0, -mapScale, 0));

	shadowColor = shadowColor / 9.0;

	shadowColor += kTransparency;
	shadowColor = clamp(shadowColor, 0.0, 1.0);

	
	vec4 color_map = texture2D(diffuseTex, gl_TexCoord[0].st);

	if(shadowUV.x >= 0.0 && shadowUV.y >= 0.0 && shadowUV.x <= 1.0 && shadowUV.y <= 1.0 )
	{

		gl_FragColor = color * shadowColor * color_map;
		//gl_FragColor = (color * shadowColor);
		//gl_FragColor = color * shadowColor; --eredeti
	}
	else
	{
		gl_FragColor = color * color_map;
		//gl_FragColor = color;
	}
}

