uniform sampler2DShadow shadowMap;
uniform sampler2D diffuseTex;
uniform sampler2D lightMapTex;
varying vec4  projCoord;

void main ()
{
	const float kTransparency = 0.4;
	vec4 color = gl_Color;

	float rValue = shadow2DProj(shadowMap, projCoord).r + kTransparency;
	rValue = clamp(rValue, 0.0, 1.0);

	vec3 coordPos  = projCoord.xyz / projCoord.w;
	vec4 color_map = texture2D(diffuseTex, gl_TexCoord[0].st);
	
	vec4 light_map = texture2D(lightMapTex, gl_TexCoord[3].st);

	if(coordPos.x >= 0.0 && coordPos.y >= 0.0 && coordPos.x <= 1.0 && coordPos.y <= 1.0 )
   	{
		gl_FragColor = (color * rValue)*color_map*light_map;
		//gl_FragColor = color;
		gl_FragColor.a = 1.0;
	}
	else
	{
		gl_FragColor = color*color_map*light_map;
		//gl_FragColor = color;
		gl_FragColor.a = 1.0;
	}
}

